<?php
/**
 * Plugin Name: MK Link Auditor
 * Description: پنل مدیریت برای بررسی و حذف لینک داخلی بین صفحات (تکی و گروهی) — نسخه بدون AJAX.
 * Version: 1.3.0
 * Author: Matin Khamooshi
 * Author URI: https://matinkhamooshi.ir/
 * Text Domain: mk-link-auditor
 * Requires at least: 6.0
 * Requires PHP: 7.4
 */


if (!defined('ABSPATH')) {
    exit;
}


// Define constants
if (!defined('MKLA_PATH')) {
    define('MKLA_PATH', plugin_dir_path(__FILE__));
}
if (!defined('MKLA_URL')) {
    define('MKLA_URL', plugin_dir_url(__FILE__));
}
if (!defined('MKLA_VER')) {
    define('MKLA_VER', '1.3.0');
}


// Includes
require_once MKLA_PATH . 'includes/AdminPage.php';
require_once MKLA_PATH . 'includes/Actions.php';
require_once MKLA_PATH . 'includes/LinkChecker.php';
require_once MKLA_PATH . 'includes/LinkRemover.php';


add_action('plugins_loaded', function () {
    load_plugin_textdomain('mk-link-auditor', false, dirname(plugin_basename(__FILE__)) . '/languages');
});


// Admin assets (CSS only)
add_action('admin_enqueue_scripts', function ($hook) {
    if ($hook !== 'toplevel_page_mk-link-auditor') {
        return;
    }
    wp_enqueue_style('mkla-admin', MKLA_URL . 'assets/admin.css', [], MKLA_VER);
});


// Admin page
add_action('admin_menu', ['MKLA_AdminPage', 'register_menu']);


// Non-AJAX form handlers
add_action('admin_post_mkla_check', ['MKLA_Actions', 'check_link']);
add_action('admin_post_mkla_remove', ['MKLA_Actions', 'remove_link']);
add_action('admin_post_mkla_remove_bulk', ['MKLA_Actions', 'remove_link_bulk']);