<?php
if (!defined('ABSPATH')) {
    exit;
}


class MKLA_LinkRemover
{


    /**
     * Remove links to $target_url while preserving inner nodes (text & images).
     * If $indices is null => remove ALL; else remove only selected indices.
     * @return array [updated(bool), new_content(string), count(int)]
     */
    public static function remove_links_from_post($post, $target_url, $indices = null)
    {
        if (!$post)
            return [false, '', 0];
        $content = (string) $post->post_content; // RAW


        $doc = new DOMDocument();
        libxml_use_internal_errors(true);
        $doc->loadHTML('<?xml encoding="utf-8" ?>' . $content);
        libxml_clear_errors();


        $normalized_targets = MKLA_LinkChecker::build_target_variants($target_url);


        $anchors = $doc->getElementsByTagName('a');
        $matches = [];
        foreach ($anchors as $a) {
            $href = $a->getAttribute('href');
            $href_norm = MKLA_LinkChecker::normalize_url(MKLA_LinkChecker::absolutize_url($href));
            if (in_array($href_norm, $normalized_targets, true)) {
                $matches[] = $a;
            }
        }
        if (empty($matches)) {
            return [false, $content, 0];
        }


        // choose occurrences
        $to_remove = [];
        if (is_array($indices) && !empty($indices)) {
            $allowed = array_map('intval', $indices);
            foreach ($matches as $i => $el) {
                if (in_array($i, $allowed, true))
                    $to_remove[] = $el;
            }
        } else {
            $to_remove = $matches; // all
        }


        // unwrap anchors
        foreach ($to_remove as $a) {
            while ($a->firstChild) {
                $a->parentNode->insertBefore($a->firstChild, $a);
            }
            if ($a->parentNode) {
                $a->parentNode->removeChild($a);
            }
        }


        // back to HTML
        $body = $doc->getElementsByTagName('body')->item(0);
        $new_html = '';
        if ($body) {
            foreach ($body->childNodes as $child) {
                $new_html .= $doc->saveHTML($child);
            }
        }


        $updated = wp_update_post([
            'ID' => $post->ID,
            'post_content' => $new_html,
        ], true);
        if (is_wp_error($updated))
            return [false, $content, 0];
        return [true, $new_html, count($to_remove)];
    }
}