<?php
if (!defined('ABSPATH')) {
    exit;
}


class MKLA_AdminPage
{
    public static function register_menu()
    {
        add_menu_page(
            __('MK Link Auditor', 'mk-link-auditor'),
            __('MK Link Auditor', 'mk-link-auditor'),
            'edit_posts',
            'mk-link-auditor',
            [__CLASS__, 'render_page'],
            'dashicons-editor-unlink',
            82
        );
    }


    public static function render_page()
    {
        if (!current_user_can('edit_posts')) {
            return;
        }


        $has_status = isset($_GET['mkla_status']);
        $status_ok = (isset($_GET['mkla_status']) && $_GET['mkla_status'] === 'ok');
        $message = isset($_GET['message']) ? sanitize_text_field(wp_unslash($_GET['message'])) : '';


        // Load last batch (target + sources) from transient
        $batch = MKLA_Actions::get_batch_transient();
        $url_target = is_array($batch) && !empty($batch['target']) ? esc_url_raw($batch['target']) : '';
        $sources = is_array($batch) && !empty($batch['sources']) ? (array) $batch['sources'] : [];


        // For UX, stringify sources for textarea
        $sources_text = !empty($sources) ? implode("
", array_map('esc_url', $sources)) : '';


        // Prepare results
        $results = [];
        if ($status_ok && $url_target && !empty($sources)) {
            foreach ($sources as $src) {
                [$post, $raw] = MKLA_LinkChecker::get_post_and_content_by_url($src);
                if (!$post || $raw === null) {
                    $results[] = [
                        'url' => $src,
                        'title' => '—',
                        'found' => false,
                        'message' => 'صفحه یافت نشد یا قابل خواندن نیست.',
                        'occ' => [],
                    ];
                    continue;
                }
                $occ = MKLA_LinkChecker::find_links($raw, $url_target);
                $msg = '';
                if (empty($occ)) {
                    $msg = '❌ لینک داده نشده.';
                } else {
                    $image_srcs = [];
                    $texts = [];
                    foreach ($occ as $o) {
                        if ($o['type'] === 'image' && !empty($o['image_srcs'])) {
                            foreach ($o['image_srcs'] as $s) {
                                $image_srcs[] = $s;
                            }
                        }
                        if (!empty($o['anchor_text'])) {
                            $texts[] = $o['anchor_text'];
                        }
                    }
                    $image_srcs = array_values(array_unique($image_srcs));
                    $texts = array_values(array_unique($texts));
                    if (!empty($image_srcs) && empty($texts)) {
                        $msg = (count($image_srcs) === 1)
                            ? '✅ لینک روی یک تصویر با آدرس «' . $image_srcs[0] . '» داده شده.'
                            : '✅ لینک روی تصاویر با آدرس‌ها: «' . implode('»، «', $image_srcs) . '» داده شده.';
                    } elseif (empty($image_srcs) && !empty($texts)) {
                        $msg = (count($texts) === 1)
                            ? '✅ لینک روی انکر تکست «' . $texts[0] . '» داده شده.'
                            : '✅ لینک روی انکر تکست‌های «' . implode('»، «', $texts) . '» داده شده.';
                    } else {
                        $parts = [];
                        if (!empty($texts))
                            $parts[] = 'متنی: «' . implode('»، «', $texts) . '»';
                        if (!empty($image_srcs))
                            $parts[] = 'تصویری: «' . implode('»، «', $image_srcs) . '»';
                        $msg = '✅ لینک داده شده — ' . implode(' — ', $parts) . '.';
                    }
                }
                $results[] = [
                    'url' => $src,
                    'title' => get_the_title($post),
                    'found' => !empty($occ),
                    'message' => $msg,
                    'occ' => $occ,
                ];
            }
        }
        ?>
        <div class="wrap mkla-wrap">
            <h1>MK Link Auditor</h1>
            <p class="description">بررسی گروهی: یک لینک هدف بده و چندین صفحه منبع را وارد کن؛ افزونه برای هر صفحه وضعیت را نشان
                می‌دهد و امکان حذف تک‌به‌تک یا حذف همهٔ لینک‌ها را می‌دهد.</p>


            <?php if ($has_status && $message): ?>
                <div class="notice notice-<?php echo $status_ok ? 'success' : 'error'; ?> is-dismissible">
                    <p><?php echo esc_html($message); ?></p>
                </div>
            <?php endif; ?>


            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <?php wp_nonce_field('mkla_nonce', 'mkla_nonce'); ?>
                <input type="hidden" name="action" value="mkla_check" />


                <table class="form-table">
                    <tr>
                        <th scope="row"><label for="mkla_url_target">لینک صفحه اول (هدف)</label></th>
                        <td>
                            <input type="url" id="mkla_url_target" name="url_target" class="regular-text ltr"
                                placeholder="https://example.com/page-to-remove" value="<?php echo esc_attr($url_target); ?>"
                                required />
                            <p class="description">صفحه‌ای که می‌خواهی لینک‌های اشاره‌کننده به آن حذف/بررسی شوند.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="mkla_url_sources">لینک صفحه‌های دوم (هر خط یک URL)</label></th>
                        <td>
                            <textarea id="mkla_url_sources" name="url_sources" class="large-text code ltr" rows="6" placeholder="https://example.com/page-1
https://example.com/page-2
https://example.com/page-3">        <?php echo esc_textarea($sources_text); ?></textarea>
                            <p class="description">می‌توانی با ویرگول هم جدا کنی؛ اما پیشنهاد می‌شود هر خط یک لینک باشد.</p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button class="button button-primary">بررسی گروهی</button>
                </p>
            </form>


            <?php if ($status_ok && $url_target && !empty($results)): ?>
                <h2 style="margin-top:16px;">نتایج بررسی</h2>
                <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
                    onsubmit="return confirm('حذف تمام لینک‌ها در همهٔ صفحات؟');" style="margin-bottom:12px;">
                    <?php wp_nonce_field('mkla_nonce', 'mkla_nonce'); ?>
                    <input type="hidden" name="action" value="mkla_remove_bulk" />
                    <input type="hidden" name="url_target" value="<?php echo esc_attr($url_target); ?>" />
                    <?php foreach ($sources as $s): ?>
                        <input type="hidden" name="url_sources[]" value="<?php echo esc_attr($s); ?>" />
                    <?php endforeach; ?>
                    <button class="button">حذف همهٔ لینک‌ها در همهٔ صفحات</button>
                </form>


                <table class="fixed widefat striped">
                    <thead>
                        <tr>
                            <th>صفحه منبع</th>
                            <th>وضعیت</th>
                            <th>خلاصه</th>
                            <th style="width: 360px;">حذف</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($results as $row): ?>
                            <tr>
                                <td>
                                    <div><strong><?php echo esc_html($row['title']); ?></strong></div>
                                    <div class="description ltr" style="word-break: break-all;"><?php echo esc_html($row['url']); ?>
                                    </div>
                                </td>
                                <td><span class="dashicons <?php echo $row['found'] ? 'dashicons-yes' : 'dashicons-no'; ?>"></span></td>
                                <td><?php echo esc_html($row['message']); ?></td>
                                <td>
                                    <?php if ($row['found']): ?>
                                        <details>
                                            <summary>نمایش موارد و حذف انتخابی</summary>
                                            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
                                                style="margin-top:8px;">
                                                <?php wp_nonce_field('mkla_nonce', 'mkla_nonce'); ?>
                                                <input type="hidden" name="action" value="mkla_remove" />
                                                <input type="hidden" name="url_target" value="<?php echo esc_attr($url_target); ?>" />
                                                <input type="hidden" name="url_source" value="<?php echo esc_attr($row['url']); ?>" />


                                                <table class="fixed widefat" style="margin:6px 0;">
                                                    <thead>
                                                        <tr>
                                                            <th style="width:50px;">#</th>
                                                            <th>نوع</th>
                                                            <th>انکر تکست</th>
                                                            <th>آدرس تصویر(ها)</th>
                                                            <th style="width:100px;">انتخاب</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($row['occ'] as $i => $o): ?>
                                                            <tr>
                                                                <td><?php echo (int) $i + 1; ?></td>
                                                                <td><?php echo $o['type'] === 'image' ? 'تصویری' : 'متنی'; ?></td>
                                                                <td><?php echo !empty($o['anchor_text']) ? esc_html($o['anchor_text']) : '—'; ?>
                                                                </td>
                                                                <td><?php echo !empty($o['image_srcs']) ? esc_html(implode('، ', $o['image_srcs'])) : '—'; ?>
                                                                </td>
                                                                <td><label><input type="checkbox" name="indices[]"
                                                                            value="<?php echo (int) $o['index']; ?>"> انتخاب</label></td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>


                                                <div style="display:flex; gap:8px;">
                                                    <button class="button button-secondary" name="remove_selected" value="1">حذف
                                                        انتخاب‌شده‌ها</button>
                                                    <button class="button" name="remove_all" value="1"
                                                        onclick="return confirm('حذف تمام لینک‌های این صفحه؟');">حذف همه در این
                                                        صفحه</button>
                                                </div>
                                            </form>
                                        </details>
                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        <?php
    }
}