<?php
if (!defined('ABSPATH')) {
    exit;
}


class MKLA_Actions
{


    private static function set_batch_transient($data)
    {
        $key = 'mkla_batch_' . get_current_user_id();
        set_transient($key, $data, 5 * MINUTE_IN_SECONDS);
        return $key;
    }
    public static function get_batch_transient()
    {
        $key = 'mkla_batch_' . get_current_user_id();
        return get_transient($key);
    }


    public static function check_link()
    {
        if (!current_user_can('edit_posts')) {
            wp_die(__('Permission denied', 'mk-link-auditor'));
        }
        if (!isset($_POST['mkla_nonce']) || !wp_verify_nonce($_POST['mkla_nonce'], 'mkla_nonce')) {
            wp_die(__('Security check failed', 'mk-link-auditor'));
        }


        $url_target = esc_url_raw($_POST['url_target'] ?? '');
        $url_source = esc_url_raw($_POST['url_source'] ?? '');
        $url_sources = isset($_POST['url_sources']) ? (string) $_POST['url_sources'] : '';


        // Build sources array without regex to avoid editor collisions
        $sources = [];
        if ($url_sources !== '') {
            $normalized = str_replace(array("
", "
",
                ","
            ), "
", $url_sources);
            // Use chr(10) to avoid backslash issues in editors
            $normalized = str_replace("
", chr(10), $normalized);
            $lines = explode(chr(10), $normalized);
            foreach ($lines as $ln) {
                $ln = trim($ln);
                if ($ln !== '') {
                    $sources[] = esc_url_raw($ln);
                }
            }
        }
        if ($url_source !== '') {
            $sources[] = $url_source;
        }
        $sources = array_values(array_unique(array_filter($sources)));


        $redirect = admin_url('admin.php?page=mk-link-auditor');


        if (!$url_target || empty($sources)) {
            wp_safe_redirect(add_query_arg([
                'mkla_status' => 'err',
                'message' => rawurlencode('لطفاً لینک هدف و حداقل یک لینک منبع را وارد کنید.'),
            ], $redirect));
            exit;
        }


        self::set_batch_transient([
            'target' => $url_target,
            'sources' => $sources,
        ]);


        wp_safe_redirect(add_query_arg([
            'mkla_status' => 'ok',
        ], $redirect));
        exit;
    }


    public static function remove_link()
    {
        if (!current_user_can('edit_posts')) {
            wp_die(__('Permission denied', 'mk-link-auditor'));
        }
        if (!isset($_POST['mkla_nonce']) || !wp_verify_nonce($_POST['mkla_nonce'], 'mkla_nonce')) {
            wp_die(__('Security check failed', 'mk-link-auditor'));
        }


        $url_target = esc_url_raw($_POST['url_target'] ?? '');
        $url_source = esc_url_raw($_POST['url_source'] ?? '');
        $indices = isset($_POST['indices']) && is_array($_POST['indices']) ? array_map('intval', $_POST['indices']) : null;
        $remove_all = !empty($_POST['remove_all']);


        $redirect = admin_url('admin.php?page=mk-link-auditor');


        $post_id = url_to_postid($url_source);
        if (!$post_id) {
            wp_safe_redirect(add_query_arg([
                'mkla_status' => 'err',
                'message' => rawurlencode('صفحه منبع یافت نشد.'),
            ], $redirect));
            exit;
        }


        $post = get_post($post_id);
        if (!$post || !current_user_can('edit_post', $post->ID)) {
            wp_safe_redirect(add_query_arg([
                'mkla_status' => 'err',
                'message' => rawurlencode('دسترسی ویرایش این پست را ندارید.'),
            ], $redirect));
            exit;
        }


        [$updated, $new_content, $count] = MKLA_LinkRemover::remove_links_from_post($post, $url_target, $remove_all ? null : $indices);
        if (!$updated) {
            wp_safe_redirect(add_query_arg([
                'mkla_status' => 'err',
                'message' => rawurlencode('لینکی یافت نشد یا مشکلی در حذف رخ داد.'),
            ], $redirect));
            exit;
        }


        wp_safe_redirect(add_query_arg([
            'mkla_status' => 'ok',
            'message' => rawurlencode(sprintf('حذف انجام شد. تعداد حذف: %d', (int) $count)),
        ], $redirect));
        exit;
    }


    public static function remove_link_bulk()
    {
        if (!current_user_can('edit_posts')) {
            wp_die(__('Permission denied', 'mk-link-auditor'));
        }
        if (!isset($_POST['mkla_nonce']) || !wp_verify_nonce($_POST['mkla_nonce'], 'mkla_nonce')) {
            wp_die(__('Security check failed', 'mk-link-auditor'));
        }


        $url_target = esc_url_raw($_POST['url_target'] ?? '');
        $url_sources = isset($_POST['url_sources']) && is_array($_POST['url_sources']) ? array_map('esc_url_raw', $_POST['url_sources']) : [];
        if (empty($url_sources)) {
            $batch = self::get_batch_transient();
            if ($batch && !empty($batch['sources'])) {
                $url_sources = $batch['sources'];
            }
        }


        $redirect = admin_url('admin.php?page=mk-link-auditor');
        if (!$url_target || empty($url_sources)) {
            wp_safe_redirect(add_query_arg([
                'mkla_status' => 'err',
                'message' => rawurlencode('داده کافی برای حذف گروهی موجود نیست.'),
            ], $redirect));
            exit;
        }


        $total = 0;
        $affected_pages = 0;
        foreach ($url_sources as $src) {
            $post_id = url_to_postid($src);
            if (!$post_id)
                continue;
            $post = get_post($post_id);
            if (!$post || !current_user_can('edit_post', $post->ID))
                continue;
            [$updated, $new_content, $count] = MKLA_LinkRemover::remove_links_from_post($post, $url_target, null);
            if ($updated && $count > 0) {
                $total += (int) $count;
                $affected_pages++;
            }
        }


        wp_safe_redirect(add_query_arg([
            'mkla_status' => 'ok',
            'message' => rawurlencode(sprintf('حذف گروهی انجام شد: %d لینک در %d صفحه.', (int) $total, (int) $affected_pages)),
        ], $redirect));
        exit;
    }
}